/*
 * Decompiled with CFR 0.152.
 */
package frc.input;

import frc.input.JInputController;
import frc.input.JInputControllerListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.ControllerEvent;
import net.java.games.input.ControllerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JInputManager
implements ControllerListener {
    private static final boolean TRACE = true;
    private static boolean DISCARD_MOUSE = true;
    public static boolean ENABLED = true;
    private static JInputManager SINGLETON;
    private final List<JInputControllerListener> listeners = new ArrayList<JInputControllerListener>();
    private final List<JInputController> controllers;

    private JInputManager() {
        if (ENABLED) {
            ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
            this.controllers = JInputManager.gatherValidControllers(controllerEnvironment);
            controllerEnvironment.addControllerListener((ControllerListener)this);
        } else {
            this.controllers = new ArrayList<JInputController>(0);
            System.out.println("Controllers discovery disabled...");
        }
    }

    public final synchronized void controllerAdded(ControllerEvent controllerEvent) {
        System.out.println("Controller added ... ");
        JInputController jInputController = JInputManager.addController(controllerEvent.getController(), this.controllers);
        if (jInputController != null) {
            System.out.println("Valid Controller plugged : " + jInputController.getName());
            for (JInputControllerListener jInputControllerListener : this.listeners) {
                jInputControllerListener.controllerPlugged(jInputController);
            }
        }
    }

    public final synchronized void controllerRemoved(ControllerEvent controllerEvent) {
        System.out.println("Controller removed ... ");
        int n = this.indexOf(controllerEvent.getController());
        if (n >= 0) {
            JInputController jInputController = this.controllers.remove(n);
            System.out.println("Valid Controller unplugged : " + jInputController.getName());
            for (JInputControllerListener jInputControllerListener : this.listeners) {
                jInputControllerListener.controllerUnplugged(jInputController);
            }
        }
    }

    public final synchronized void addControllerListener(JInputControllerListener jInputControllerListener) {
        this.listeners.add(jInputControllerListener);
    }

    public final synchronized void removeControllerListener(JInputControllerListener jInputControllerListener) {
        this.listeners.remove(jInputControllerListener);
    }

    public final synchronized int getControllersCount() {
        return this.controllers.size();
    }

    public final synchronized boolean contains(JInputController jInputController) {
        return this.controllers.contains(jInputController);
    }

    public final synchronized List<JInputController> getControllers() {
        ArrayList<JInputController> arrayList = new ArrayList<JInputController>(this.controllers.size());
        arrayList.addAll(this.controllers);
        return arrayList;
    }

    public final synchronized JInputController getController(String string) {
        int n = this.indexOf(string);
        return n < 0 ? null : this.controllers.get(n);
    }

    private final int indexOf(Object object) {
        int n = this.controllers.size();
        while (n-- > 0) {
            if (!this.controllers.get(n).embodies(object)) continue;
            return n;
        }
        return -1;
    }

    public static final synchronized JInputManager getDebugManager() {
        if (DISCARD_MOUSE) {
            DISCARD_MOUSE = false;
            SINGLETON = null;
        }
        return JInputManager.getDefaultManager();
    }

    public static final synchronized JInputManager getDefaultManager() {
        if (SINGLETON == null) {
            SINGLETON = new JInputManager();
        }
        return SINGLETON;
    }

    private static final List<JInputController> gatherValidControllers(ControllerEnvironment controllerEnvironment) {
        ArrayList<JInputController> arrayList = new ArrayList<JInputController>();
        Controller[] controllerArray = JInputManager.getControllers(controllerEnvironment);
        int n = 0;
        while (n < controllerArray.length) {
            JInputManager.addController(controllerArray[n], arrayList);
            ++n;
        }
        return arrayList;
    }

    private static final JInputController addController(Controller controller, List<JInputController> list) {
        try {
            if (JInputManager.isValidController(controller)) {
                JInputController jInputController = new JInputController(controller);
                list.add(jInputController);
                return jInputController;
            }
        }
        catch (Exception exception) {
            System.err.println("*** Error while creating candidate controller");
            exception.printStackTrace(System.err);
        }
        return null;
    }

    private static final boolean isValidController(Controller controller) {
        Controller.Type type = controller.getType();
        if (DISCARD_MOUSE && type == Controller.Type.MOUSE) {
            return false;
        }
        if (type == Controller.Type.KEYBOARD) {
            return false;
        }
        if (controller.getName().toLowerCase().indexOf("keyboard") >= 0) {
            return false;
        }
        Component[] componentArray = controller.getComponents();
        boolean bl = false;
        int n = componentArray.length;
        while (n-- > 0) {
            Component.Identifier identifier = componentArray[n].getIdentifier();
            if (!(identifier instanceof Component.Identifier.Axis)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static final Controller[] getControllers(ControllerEnvironment controllerEnvironment) {
        PrintStream printStream = System.out;
        PrintStream printStream2 = new PrintStream(printStream, true){

            public void println(String string) {
                if (string == null || !string.startsWith("Loading: ")) {
                    super.println(string);
                }
            }
        };
        try {
            System.setOut(printStream2);
            Controller[] controllerArray = controllerEnvironment.getControllers();
            return controllerArray;
        }
        finally {
            System.setOut(printStream);
        }
    }
}

